unit MainUnit;

//  .
//     ,
//     . 
//  TImage  TShape.   TShape
// (Style)    .
//      .

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, jpeg;

type
  TForm1 = class(TForm)
    ShapeCircle: TShape;
    Shape2: TShape;
    Shape3: TShape;
    Shape4: TShape;
    Shape5: TShape;
    Shape6: TShape;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Bevel2: TBevel;
    Image2: TImage;
    CBoxBrushStyle: TComboBox;
    Panel1: TPanel;
    ButtonBrushColor: TButton;
    ButtonPenColor: TButton;
    STextBrushColor: TStaticText;
    ShapeShadow: TShape;
    STextPenColor: TStaticText;
    ColorDialog1: TColorDialog;
    LabelTitle: TLabel;
    Bevel3: TBevel;
    Label7: TLabel;
    Label8: TLabel;
    procedure CBoxBrushStyleChange(Sender: TObject);
    procedure ButtonBrushColorClick(Sender: TObject);
    procedure ButtonPenColorClick(Sender: TObject);
  private
    { Private declarations }
    procedure EnumShapes (RqMod : Char);
    procedure ShapesModify (RqMod : Char; RqShape : TShape);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.ShapesModify (RqMod : Char; RqShape : TShape);
begin
  case RqMod of
  'S' : begin
          case CBoxBrushStyle.ItemIndex of
           0 : RqShape.Brush.Style := bsSolid;
           1 : RqShape.Brush.Style := bsClear;
           2 : RqShape.Brush.Style := bsHorizontal;
           3 : RqShape.Brush.Style := bsVertical;
           4 : RqShape.Brush.Style := bsFDiagonal;
           5 : RqShape.Brush.Style := bsBDiagonal;
           6 : RqShape.Brush.Style := bsCross;
           7 : RqShape.Brush.Style := bsDiagCross;
           end;
        end;
  'B' : RqShape.Brush.Color := STextBrushColor.Color;
  'P' : RqShape.Pen.Color := STextPenColor.Color;

  end;
end;

procedure TForm1.EnumShapes (RqMod : Char);
var Ind    : integer;
    WShape : TShape;
begin
 if Panel1.ControlCount > 0
 then begin
    for Ind := 0 to Panel1.ControlCount - 1 do
    begin
      if Panel1.Controls[Ind] is TShape
      then begin
        WShape := Panel1.Controls[Ind] as TShape;
        if WShape.Name <> 'ShapeShadow'
        then begin
           ShapesModify (RqMod, WShape);
        end;
      end;
    end;
 end;
end;

procedure TForm1.CBoxBrushStyleChange(Sender: TObject);
begin
 EnumShapes ('S');
end;


procedure TForm1.ButtonBrushColorClick(Sender: TObject);
begin
 if ColorDialog1.Execute
 then begin
   STextBrushColor.Color := ColorDialog1.Color;
   EnumShapes ('B');
 end;
end;

procedure TForm1.ButtonPenColorClick(Sender: TObject);
begin
if ColorDialog1.Execute
 then begin
   STextPenColor.Color := ColorDialog1.Color;
   EnumShapes ('P');
 end;
end;

end.
